<?php

namespace App\Livewire\Dashbord;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\EstadoPlanta;
use App\Models\AnalisisLinea;
use Illuminate\Support\Facades\DB;
use App\Models\SolicitudAnalisisLinea;

class Planta extends Component
{

    public $R1;
    public $R2;
    public $R3;
    public $TK41;
    public $TKMIX3;
    public $TKMIX2;
    public $TK42;
    public $TKMIX1;
    public $TKMIX4;
    public $TtkQuesos;
    public $marmita;
    public $TK10;
    public $TKFP;
    public $TKMP;
    public $TK5;
    public $TKFG;
    public $TKMG;
    public $TKCC;
    public $TKSC;
    //PASTEURIZADORES
    public $maguer;
    public $tetra;
    public $ultra;
    //ENVASADORAS
    //grupo1
    public $HTST_1A, $HTST_1B, $HTST_1C;
    public $HTST_2A, $HTST_2B, $HTST_2C;
    //grupo2
    public $HTST_3A, $HTST_3B, $HTST_3C;
    public $HTST_4A, $HTST_4B, $HTST_4C;
    public $HTST_5A, $HTST_5B, $HTST_5C;
    //grupo3
    public $UHT_1A, $UHT_1B, $UHT_1C;
    public $UHT_2A, $UHT_2B;
    public $UHT_3A, $UHT_3B;
    //grupo4
    public $V1, $V2, $V3;
    //grupo5
    public $araña;


    #[On('actualizar_dashboardPlanta')]
    public function render()
    {
        //R1
        $this->R1 = EstadoPlanta::where('origen_id', '6')->latest('created_at')->first();
        //R2
        $this->R2 = EstadoPlanta::where('origen_id', '7')->latest('created_at')->first();
        //R3
        $this->R3 = EstadoPlanta::where('origen_id', '8')->latest('created_at')->first();
        //TK41
        $this->TK41 = EstadoPlanta::where('origen_id', '9')->latest('created_at')->first();
        //TKMIX3
        $this->TKMIX3 = EstadoPlanta::where('origen_id', '10')->latest('created_at')->first();
        //TKMIX2
        $this->TKMIX2 = EstadoPlanta::where('origen_id', '11')->latest('created_at')->first();
        //TK42
        $this->TK42 = EstadoPlanta::where('origen_id', '12')->latest('created_at')->first();
        //TKMIX4
        $this->TKMIX1 = EstadoPlanta::where('origen_id', '13')->latest('created_at')->first();
        //TKMIX1
        $this->TKMIX4 = EstadoPlanta::where('origen_id', '14')->latest('created_at')->first();
        //TtkQuesos
        $this->TtkQuesos = EstadoPlanta::where('origen_id', '15')->latest('created_at')->first();
        //marmita
        $this->marmita = EstadoPlanta::where('origen_id', '16')->latest('created_at')->first();
        //TK10
        $this->TK10 = EstadoPlanta::where('origen_id', '17')->latest('created_at')->first();
        //TKFP
        $this->TKFP = EstadoPlanta::where('origen_id', '18')->latest('created_at')->first();
        //TKFP
        $this->TKMP = EstadoPlanta::where('origen_id', '49')->latest('created_at')->first();
        //TK5
        $this->TK5 = EstadoPlanta::where('origen_id', '19')->latest('created_at')->first();
        //TKFG
        $this->TKFG = EstadoPlanta::where('origen_id', '20')->latest('created_at')->first();
        //TKMG
        $this->TKMG = EstadoPlanta::where('origen_id', '21')->latest('created_at')->first();
        //TKCC
        $this->TKCC = EstadoPlanta::where('origen_id', '22')->latest('created_at')->first();
        //TKSC
        $this->TKSC = EstadoPlanta::where('origen_id', '23')->latest('created_at')->first();
        //maguer
        $this->maguer = EstadoPlanta::where('origen_id', '24')->latest('created_at')->first();
        //tetra
        $this->tetra = EstadoPlanta::where('origen_id', '25')->latest('created_at')->first();
        //ultra
        $this->ultra = EstadoPlanta::where('origen_id', '26')->latest('created_at')->first();
        //CONULTA DE ENVASADORAS
        //HTST
        $this->HTST_1A = EstadoPlanta::where('origen_id', '48')->latest('created_at')->first();
        $this->HTST_1B = EstadoPlanta::where('origen_id', '47')->latest('created_at')->first();
        $this->HTST_1C = EstadoPlanta::where('origen_id', '46')->latest('created_at')->first();

        $this->HTST_2A = EstadoPlanta::where('origen_id', '45')->latest('created_at')->first();
        $this->HTST_2B = EstadoPlanta::where('origen_id', '44')->latest('created_at')->first();
        $this->HTST_2C = EstadoPlanta::where('origen_id', '43')->latest('created_at')->first();

        $this->HTST_3A = EstadoPlanta::where('origen_id', '42')->latest('created_at')->first();
        $this->HTST_3B = EstadoPlanta::where('origen_id', '41')->latest('created_at')->first();
        $this->HTST_3C = EstadoPlanta::where('origen_id', '40')->latest('created_at')->first();

        $this->HTST_4A = EstadoPlanta::where('origen_id', '39')->latest('created_at')->first();
        $this->HTST_4B = EstadoPlanta::where('origen_id', '38')->latest('created_at')->first();
        $this->HTST_4C = EstadoPlanta::where('origen_id', '37')->latest('created_at')->first();

        $this->HTST_5A = EstadoPlanta::where('origen_id', '36')->latest('created_at')->first();
        $this->HTST_5B = EstadoPlanta::where('origen_id', '35')->latest('created_at')->first();
        $this->HTST_5C = EstadoPlanta::where('origen_id', '34')->latest('created_at')->first();

        //UHT
        $this->UHT_1A = EstadoPlanta::where('origen_id', '27')->latest('created_at')->first();
        $this->UHT_1B = EstadoPlanta::where('origen_id', '28')->latest('created_at')->first();
        $this->UHT_1C = EstadoPlanta::where('origen_id', '29')->latest('created_at')->first();

        $this->UHT_2A = EstadoPlanta::where('origen_id', '30')->latest('created_at')->first();
        $this->UHT_2B = EstadoPlanta::where('origen_id', '31')->latest('created_at')->first();

        $this->UHT_3A = EstadoPlanta::where('origen_id', '32')->latest('created_at')->first();
        $this->UHT_3B = EstadoPlanta::where('origen_id', '33')->latest('created_at')->first();

        //VASOS
        $this->V1 = EstadoPlanta::where('origen_id', '50')->latest('created_at')->first();
        $this->V2 = EstadoPlanta::where('origen_id', '51')->latest('created_at')->first();
        $this->V3 = EstadoPlanta::where('origen_id', '52')->latest('created_at')->first();

        //ARAñA
        $this->araña = EstadoPlanta::where('origen_id', '53')->latest('created_at')->first();
        return view('livewire.dashbord.planta');
    }

    public function solicitar($id)
    {
        try {
            $solicitud = SolicitudAnalisisLinea::create([
                'tiempo' => now(),
                'user_id' => auth()->user()->id,
                'estado_planta_id' => $id,
                'estado' => 'Pendiente',
            ]);
            $id_sol = $solicitud->id;

            AnalisisLinea::create([
                'solicitud_analisis_linea_id' => $id_sol,
                'olor' => 1,
                'color' => 1,
                'sabor' => 1,
            ]);

            $this->dispatch('success', mensaje: 'Solicitud registrado exitosamente');
        } catch (\Throwable $th) {
            $this->dispatch('error', mensaje: 'Error: ' . $th);
        }
    }
}
