<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->id();
            $table->string('codigo')->unique();
            $table->string('nombre');
            $table->string('cantidad')->nullable();
            $table->string('empaque')->nullable();
            $table->foreignId('unidad_id')->nullable()->constrained()->onDelete('restrict');
            $table->foreignId('categoria_producto_id')->nullable()->constrained()->onDelete('restrict');
            $table->foreignId('destino_producto_id')->nullable()->constrained()->onDelete('restrict');
            $table->timestamps();
            $table->integer('norma')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productos');
    }
};
