<div wire:poll.300s>
    <div
        class="grid border border-gray-200 rounded-lg shadow-sm dark:border-gray-700 md:mb-12 md:grid-cols-2 bg-white dark:bg-gray-800">
        <!--Pasteurizado-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white ">Sala de Pasteurizado</h5>

            <!--TKMIX1 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMIX1): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mix1-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMIX1->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMIX1->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                    
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Produccion' || $TKMIX1->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX1->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Produccion' || $TKMIX1->proceso == 'Almacen' ): ?>
                        <?php echo e($TKMIX1->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="mix1-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Produccion' || $TKMIX1->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX1->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKMIX1->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMIX1 =
                            $TKMIX1->solicitudAnalisisLinea[count($TKMIX1->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMIX1->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:<?php echo e($ultimo_TKMIX1->analisisLinea->temperatura); ?>

                            [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>:<?php echo e($ultimo_TKMIX1->analisisLinea->ph); ?></p>
                        <p><Span class="inline-block w-32">Ac.</Span>:<?php echo e($ultimo_TKMIX1->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>:<?php echo e($ultimo_TKMIX1->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMIX1->proceso == 'Produccion' || $TKMIX1->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMIX1->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKMIX1 FIN-->

            <!--TKMIX2 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMIX2): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mix2-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMIX2->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMIX2->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                    

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso = 'Produccion' || $TKMIX2->proceso = 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX2->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso = 'Produccion' || $TKMIX2->proceso = 'Almacen' ): ?>
                        <?php echo e($TKMIX2->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="mix2-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Produccion' || $KMIX2->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX2->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKMIX2->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMIX2 =
                            $TKMIX2->solicitudAnalisisLinea[count($TKMIX2->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMIX2->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKMIX2->analisisLinea->temperatura); ?>[°C] </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKMIX2->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKMIX2->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKMIX2->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMIX2->proceso == 'Produccion' || $TKMIX2->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMIX2->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKMIX2 FIN-->

            <!--TKMIX3 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMIX3): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mix3-analizar-popover">
                    <p class="flex">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMIX3->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMIX3->tiempo)->isoFormat('HH:mm')); ?>

                    </p>


                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Produccion' || $TKMIX3->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX3->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Produccion' || $TKMIX3->proceso == 'Almacen' ): ?>
                        <?php echo e($TKMIX3->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="mix3-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Produccion' || $TKMIX3->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX3->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKMIX3->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMIX3 =
                            $TKMIX3->solicitudAnalisisLinea[count($TKMIX3->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMIX3->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKMIX3->analisisLinea->temperatura); ?> </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKMIX3->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKMIX3->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKMIX3->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMIX3->proceso == 'Produccion' || $TKMIX3->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMIX3->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKMIX3 FIN-->

            <!--TKMIX4 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMIX4): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mix4-analizar-popover">
                    <p class="flex gap-1">
                        
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Produccion'): ?>
                            <span class="flex items-center text-sm font-medium me-3"><span
                                    class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Limpieza'): ?>
                            <span class="flex items-center text-sm font-medium me-3"><span
                                    class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Mantenimiento'): ?>
                            <span class="flex items-center text-sm font-medium me-3"><span
                                    class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Vacio'): ?>
                            <span class="flex items-center text-sm font-medium me-3"><span
                                    class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Almacen'): ?>
                            <span class="flex items-center text-sm font-medium me-3"><span
                                    class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    
    
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMIX4->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMIX4->tiempo)->isoFormat('HH:mm')); ?>

                    </p>


                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Produccion' || $TKMIX4->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX4->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Produccion' || $TKMIX4->proceso == 'Almacen' ): ?>
                        <?php echo e($TKMIX4->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="mix4-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Produccion' || $TKMIX4->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMIX4->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>

                    <div class="px-3 py-2">
                        <?php if(count($TKMIX4->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMIX4 =
                            $TKMIX4->solicitudAnalisisLinea[count($TKMIX4->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMIX4->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKMIX4->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKMIX4->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKMIX4->analisisLinea->acidez); ?> [%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKMIX4->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMIX4->proceso == 'Produccion' || $TKMIX4->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMIX4->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKMIX4 FIN-->

            <!--TK41 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TK41): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tk41-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TK41->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TK41->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                  

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Produccion' || $TK41->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK41->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Produccion' || $TK41->proceso == 'Almacen' ): ?>
                        <?php echo e($TK41->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="tk41-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Produccion' || $TK41->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK41->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TK41->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TK41 =
                            $TK41->solicitudAnalisisLinea[count($TK41->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TK41->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TK41->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TK41->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TK41->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TK41->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TK41->proceso == 'Produccion' || $TK41->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">

                        <button type="button" wire:click="solicitar(<?php echo e($TK41->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TK41 FIN-->

            <!--TK42 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">

                <!--[if BLOCK]><![endif]--><?php if($TK42): ?>


                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tk42-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TK42->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TK42->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                   

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Produccion' || $TK42->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK42->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Produccion' || $TK42->proceso == 'Almacen' ): ?>
                        <?php echo e($TK42->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="tk42-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Produccion' || $TK42->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK42->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TK42->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TK42 =
                            $TK42->solicitudAnalisisLinea[count($TK42->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TK42->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TK42->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TK42->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TK42->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TK42->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->

                    <!--[if BLOCK]><![endif]--><?php if($TK42->proceso == 'Produccion' || $TK42->proceso == 'Almacen'): ?>

                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TK42->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TK42 FIN-->
        </figure>
        <!--saborizado-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white ">Sala de Saborizado</h5>

            <!--TK10 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TK10): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tk10-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->



                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TK10->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TK10->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Produccion' || $TK10->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK10->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Produccion' || $TK10->proceso == 'Almacen' ): ?>
                        <?php echo e($TK10->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="tk10-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Produccion' || $TK10->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK10->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TK10->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TK10 =
                            $TK10->solicitudAnalisisLinea[count($TK10->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TK10->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp,</Span>:
                            <?php echo e($ultimo_TK10->analisisLinea->temperatura); ?>[°C] </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TK10->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TK10->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TK10->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TK10->proceso == 'Produccion' || $TK10->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TK10->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TK10 FIN-->

            <!--TK5 INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TK5): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tk5-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->



                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TK5->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TK5->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Produccion' || $TK5->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK5->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Produccion' || $TK5->proceso == 'Almacen' ): ?>
                        <?php echo e($TK5->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="tk5-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Produccion' || $TK5->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TK5->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TK5->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TK5 =
                            $TK5->solicitudAnalisisLinea[count($TK5->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TK5->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TK5->analisisLinea->temperatura); ?>[°C] </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TK5->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TK5->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TK5->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TK5->proceso == 'Produccion' || $TK5->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TK5->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TK5 FIN-->

            <!--TKFP INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKFP): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tkfp-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKFP->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKFP->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Produccion' || $TKFP->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKFP->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Produccion' || $TKFP->proceso == 'Almacen' ): ?>
                        <?php echo e($TKFP->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="tkfp-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Produccion' || $TKFP->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKFP->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKFP->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKFP =
                            $TKFP->solicitudAnalisisLinea[count($TKFP->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKFP->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKFP->analisisLinea->temperatura); ?> </p>[°C]
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKFP->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKFP->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKFP->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKFP->proceso == 'Produccion' || $TKFP->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKFP->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKFP FIN-->


            <!--MP INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMP): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mp-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMP->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMP->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Produccion' || $TKMP->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMP->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Produccion' || $TKMP->proceso == 'Almacen' ): ?>
                        <?php echo e($TKMP->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="mp-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Produccion' || $TKMP->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMP->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKMP->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMP =
                            $TKMP->solicitudAnalisisLinea[count($TKMP->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMP->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKMP->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKMP->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKMP->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKMP->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMP->proceso == 'Produccion' || $TKMP->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMP->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--MP FIN-->
            <!--FG INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKFG): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="fg-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKFG->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKFG->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                    
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Produccion' || $TKFG->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKFG->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Produccion' || $TKFG->proceso == 'Almacen' ): ?>
                        <?php echo e($TKFG->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="fg-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Produccion' || $TKFG->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKFG->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKFG->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKFG =
                            $TKFG->solicitudAnalisisLinea[count($TKFG->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKFG->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKFG->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKFG->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKFG->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKFG->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKFG->proceso == 'Produccion' || $TKFG->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKFG->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--FG FIN-->

            <!--MG INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKMG): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="mg-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKMG->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKMG->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Produccion' || $TKMG->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMG->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Produccion' || $TKMG->proceso == 'Almacen' ): ?>
                        <?php echo e($TKMG->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="mg-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Produccion' || $TKMG->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKMG->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKMG->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKMG =
                            $TKMG->solicitudAnalisisLinea[count($TKMG->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKMG->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKMG->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKMG->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKMG->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKMG->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKMG->proceso == 'Produccion' || $TKMG->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKMG->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--MG FIN-->




        </figure>
        <!--Vasos-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white ">Sala de Vasos</h5>

            <!--TKCC INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKCC): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tkcc-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKCC->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKCC->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Produccion' || $TKCC->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKCC->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Produccion' || $TKCC->proceso == 'Almacen' ): ?>
                        <?php echo e($TKCC->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="tkcc-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Produccion' || $TKCC->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKCC->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKCC->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKCC =
                            $TKCC->solicitudAnalisisLinea[count($TKCC->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKCC->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKCC->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKCC->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKCC->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKCC->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKCC->proceso == 'Produccion' || $TKCC->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKCC->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKCC FIN-->

            <!--TKSC INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($TKSC): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tksc-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($TKSC->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($TKSC->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                    
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Produccion' || $TKSC->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKSC->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Produccion' || $TKSC->proceso == 'Almacen' ): ?>
                        <?php echo e($TKSC->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="tksc-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Produccion' || $TKSC->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $TKSC->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($TKSC->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_TKSC =
                            $TKSC->solicitudAnalisisLinea[count($TKSC->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_TKSC->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_TKSC->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_TKSC->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_TKSC->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_TKSC->analisisLinea->brix); ?> [°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($TKSC->proceso == 'Produccion' || $TKSC->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($TKSC->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--TKSC FIN-->
        </figure>
        <!--Recepcion-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white">Recepción</h5>

            <!-- R1 INICIO -->
            <div class="p-2 mb-2 rounded-lg border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($R1): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="r1-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($R1->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($R1->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                    

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Produccion' || $R1->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R1->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="r1-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Produccion' || $R1->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R1->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($R1->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_R1 =
                            $R1->solicitudAnalisisLinea[count($R1->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span>Estado Analisis</Span>: <?php echo e($ultimo_R1->estado); ?> </p>
                        <p><Span>Temp.</Span>: <?php echo e($ultimo_R1->analisisLinea->temperatura); ?>[°C] </p>
                        <p><Span>pH</Span>: <?php echo e($ultimo_R1->analisisLinea->ph); ?> </p>
                        <p><Span>Ac.</Span>: <?php echo e($ultimo_R1->analisisLinea->acidez); ?>[%]</p>
                        <p><Span>Sólidos</Span>: <?php echo e($ultimo_R1->analisisLinea->brix); ?> [°Bx]</p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($R1->proceso == 'Produccion' || $R1->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($R1->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!-- R1 FIN -->

            <!-- R2 INICIO -->
            <div class="p-2 mb-2 rounded-lg border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($R2): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="r2-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($R2->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($R2->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                    

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Produccion' || $R2->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R2->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="r2-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Produccion' || $R2->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R2->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($R2->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_R2 =
                            $R2->solicitudAnalisisLinea[count($R2->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span>Estado Analisis</Span>: <?php echo e($ultimo_R2->estado); ?> </p>
                        <p><Span>Temp.</Span>: <?php echo e($ultimo_R2->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span>pH</Span>: <?php echo e($ultimo_R2->analisisLinea->ph); ?> </p>
                        <p><Span>Ac.</Span>: <?php echo e($ultimo_R2->analisisLinea->acidez); ?>[%]</p>
                        <p><Span>Sólidos</Span>: <?php echo e($ultimo_R2->analisisLinea->brix); ?>[°Bx] </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($R2->proceso == 'Produccion' || $R2->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($R2->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!-- R2 FIN -->

            <!-- R3 INICIO -->
            <div class="p-2 mb-2 rounded-lg border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($R3): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="r3-analizar-popover">
                    <p class="flex gap-1">

                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($R3->origen->alias); ?>

                    </p>
                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($R3->tiempo)->isoFormat('HH:mm')); ?>

                    </p>
                   

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Produccion' || $R3->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R3->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="r3-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Produccion' || $R3->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $R3->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($R3->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_R3 =
                            $R3->solicitudAnalisisLinea[count($R3->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span>Estado Analisis</Span>: <?php echo e($ultimo_R3->estado); ?> </p>
                        <p><Span>Temp.</Span>: <?php echo e($ultimo_R3->analisisLinea->temperatura); ?>[°C] </p>
                        <p><Span>pH</Span>: <?php echo e($ultimo_R3->analisisLinea->ph); ?> </p>
                        <p><Span>Ac.</Span>: <?php echo e($ultimo_R3->analisisLinea->acidez); ?>[%]</p>
                        <p><Span>Sólidos</Span>: <?php echo e($ultimo_R3->analisisLinea->brix); ?>[°Bx]</p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($R3->proceso == 'Produccion' || $R3->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($R3->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!-- R3 FIN -->



        </figure>
        <!--Pasteurizador-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white ">Pasteurizadores</h5>

            <!--maguer INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="maguer-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($maguer->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($maguer->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                    

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Produccion' || $maguer->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $maguer->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Produccion' || $maguer->proceso == 'Almacen' ): ?>
                        <?php echo e($maguer->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>
                <div data-popover id="maguer-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Produccion' || $maguer->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $maguer->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($maguer->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_maguer =
                            $maguer->solicitudAnalisisLinea[count($maguer->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_maguer->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_maguer->analisisLinea->temperatura); ?> </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_maguer->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_maguer->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_maguer->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($maguer->proceso == 'Produccion' || $maguer->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($maguer->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
            <!--maguer FIN-->


            <!--ultra INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($ultra): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="ultra-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($ultra->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($ultra->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                    

                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Produccion' || $ultra->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $ultra->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Produccion' || $ultra->proceso == 'Almacen' ): ?>
                        <?php echo e($ultra->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="ultra-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Produccion' || $ultra->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $ultra->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>
                    <div class="px-3 py-2">
                        <?php if(count($ultra->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_ultra =
                            $ultra->solicitudAnalisisLinea[count($ultra->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_ultra->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_ultra->analisisLinea->temperatura); ?> </p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_ultra->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_ultra->analisisLinea->acidez); ?>[%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_ultra->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($ultra->proceso == 'Produccion' || $ultra->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($ultra->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--ultra FIN-->

            <!--tetra INICIO-->
            <div class="p-2 mb-2 rounded-lg  border-gray-500 hover:bg-gray-100 hover:dark:bg-gray-700 border">
                <!--[if BLOCK]><![endif]--><?php if($tetra): ?>
                <div class="grid grid-cols-4 gap-1 text-sm" data-popover-target="tetra-analizar-popover">
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Produccion'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-green-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Limpieza'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-white rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Mantenimiento'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-blue-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Vacio'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-gray-500 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Almacen'): ?>
                        <span class="flex items-center text-sm font-medium me-3"><span
                                class="flex w-2.5 h-2.5 bg-orange-600 rounded-full me-1.5 flex-shrink-0"></span></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->



                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path transform="scale(0.8 0.8)"
                                d="M237.109 145.655L217.461 145.691C214.08 145.703 209.998 146.151 206.721 145.446L206.25 145.337C168.98 137.037 169.336 81.1106 208.802 74.7749C215.208 73.7465 222.256 74.3548 228.766 74.3554L403.742 74.3688C408.358 74.0686 413.195 74.352 417.832 74.353L427.229 74.3635C471.968 74.4766 474.175 139.192 434.637 145.31C432.196 145.687 429.594 145.595 427.128 145.611L237.109 145.655Z" />
                            <path transform="scale(0.8 0.8)"
                                d="M442.37 551.275L192.626 551.259C188.48 551.252 182.971 551.741 179.063 550.408L176.796 549.731C157.703 544.312 143.897 529.168 138.837 510.345C135.986 499.737 137.431 488.224 137.426 477.314L137.428 260.547C137.481 248.452 143.304 241.502 150.055 231.823L193.12 168.771C195.019 166.123 196.779 163.177 199.225 161.002L441.895 161.046C445.811 162.84 449.763 170.636 452.225 174.202L490.248 229.658C496.708 239.148 504.17 247.972 504.234 260.011L504.179 497.862C504.069 526.62 483.354 548.942 454.4 551.147C450.441 551.449 446.345 551.277 442.37 551.275Z" />
                        </svg>
                        <?php echo e($tetra->origen->alias); ?>

                    </p>

                    <p class="flex gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                            class="w-4 h-4 fill-gray-800 dark:fill-gray-400">
                            <path
                                d="M464 256A208 208 0 1 1 48 256a208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120V256c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z" />
                        </svg>
                        <?php echo e(\Carbon\Carbon::parse($tetra->tiempo)->isoFormat('HH:mm')); ?>

                    </p>

                   
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Produccion' || $tetra->proceso == 'Almacen' ): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tetra->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($item->orp->codigo); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                    <p class="flex gap-1">
                        <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Produccion' || $tetra->proceso == 'Almacen' ): ?>
                        <?php echo e($tetra->etapa->nombre); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </p>
                </div>

                <div data-popover id="tetra-analizar-popover" role="tooltip"
                    class="absolute z-50 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
                    <div
                        class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
                        <h3 class="font-semibold text-gray-900 dark:text-white">
                            <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Produccion' || $tetra->proceso == 'Almacen' ): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tetra->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        </h3>
                    </div>

                    <div class="px-3 py-2">
                        <?php if(count($tetra->solicitudAnalisisLinea) > 0): ?>
                        <p class="hidden"><?php echo e($ultimo_tetra =
                            $tetra->solicitudAnalisisLinea[count($tetra->solicitudAnalisisLinea)-1]); ?></p>
                        <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_tetra->estado); ?> </p>
                        <p><Span class="inline-block w-32">Temp.</Span>:
                            <?php echo e($ultimo_tetra->analisisLinea->temperatura); ?> [°C]</p>
                        <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_tetra->analisisLinea->ph); ?> </p>
                        <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_tetra->analisisLinea->acidez); ?> [%]</p>
                        <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_tetra->analisisLinea->brix); ?>[°Bx]
                        </p>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <!--boton de solicitar-->
                    <!--[if BLOCK]><![endif]--><?php if($tetra->proceso == 'Produccion' || $tetra->proceso == 'Almacen'): ?>
                    <div class="px-3 py-2">
                        <button type="button" wire:click="solicitar(<?php echo e($tetra->id); ?>)"
                            class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 448 512">
                                <path
                                    d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                            </svg>
                        </button>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--tetra FIN-->


        </figure>
        <!--Enavasadora-->
        <figure
            class="  p-3  bg-white border-b border-gray-200 rounded-t-lg md:rounded-t-none md:rounded-ss-lg md:border-e dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white ">Envasadoras</h5>

            <div class="lg:flex gap-6 mb-2">
                <div class="">
                    HTST GRUPO 1
                    <div class="grid grid-cols-6 gap-1 text-center">
                        <!--[if BLOCK]><![endif]--><?php if($HTST_1A): ?>
                        <div data-popover-target="HTST_1A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_1A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_1A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_1B): ?>
                        <div data-popover-target="HTST_1B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_1B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_1B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_1C): ?>
                        <div data-popover-target="HTST_1C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_1C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_1C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($HTST_2A): ?>
                        <div data-popover-target="HTST_2A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_2A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_2A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            2A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_2B): ?>
                        <div data-popover-target="HTST_2B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_2B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_2B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            2B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_2C): ?>
                        <div data-popover-target="HTST_2C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_2C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_2C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            2C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="">
                    HTST GRUPO 2
                    <div class="grid grid-cols-9 gap-1 text-center">
                        <!--[if BLOCK]><![endif]--><?php if($HTST_3A): ?>
                        <div data-popover-target="HTST_3A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_3A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_3A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            3A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_3B): ?>
                        <div data-popover-target="HTST_3B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_3B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_3B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            3B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_3C): ?>
                        <div data-popover-target="HTST_3C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_3C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_3C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            3C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_4A): ?>
                        <div data-popover-target="HTST_4A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_4A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_4A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            4A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_4B): ?>
                        <div data-popover-target="HTST_4B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_4B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_4B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            4B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_4C): ?>
                        <div data-popover-target="HTST_4C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_4C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_4C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            4C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_5A): ?>
                        <div data-popover-target="HTST_5A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_5A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_5A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            5A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_5B): ?>
                        <div data-popover-target="HTST_5B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_5B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_5B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            5B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($HTST_5C): ?>
                        <div data-popover-target="HTST_5C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($HTST_5C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($HTST_5C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            5C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <div class="lg:flex gap-6 mb-2">
                <div class="">
                    UHT
                    <div class="grid grid-cols-7 gap-1 text-center">
                        <!--[if BLOCK]><![endif]--><?php if($UHT_1A): ?>
                        <div data-popover-target="UHT_1A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_1A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_1A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_1B): ?>
                        <div data-popover-target="UHT_1B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_1B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_1B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_1C): ?>
                        <div data-popover-target="UHT_1C-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_1C->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_1C->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            1C
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_2A): ?>
                        <div data-popover-target="UHT_2A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_2A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_2A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            2A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_2B): ?>
                        <div data-popover-target="UHT_2B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_2B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_2B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            2B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_3A): ?>
                        <div data-popover-target="UHT_3A-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_3A->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_3A->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            3A
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($UHT_3B): ?>
                        <div data-popover-target="UHT_3B-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($UHT_3B->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($UHT_3B->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            3B
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="">
                    Vasos
                    <div class="grid grid-cols-3 gap-1 text-center">
                        <!--[if BLOCK]><![endif]--><?php if($V1): ?>
                        <div data-popover-target="V1-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($V1->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($V1->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            V1
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($V2): ?>
                        <div data-popover-target="V2-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($V2->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($V2->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            V2
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($V3): ?>
                        <div data-popover-target="V3-popover"
                            class="p-2 mb-2 rounded-lg  border-<?php echo e($V3->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($V3->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                            V3
                        </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <div class="">
                Embotelladora
                <div class="grid grid-cols-1 gap-1 text-center">
                    <!--[if BLOCK]><![endif]--><?php if($araña): ?>
                    <div data-popover-target="araña-popover"
                        class="p-2 mb-2 rounded-lg  border-<?php echo e($araña->proceso=='Produccion' ? 'green' : 'red'); ?>-500 hover:bg-gray-100  hover:dark:bg-gray-700 border text-<?php echo e($araña->proceso=='Produccion' ? 'green' : 'red'); ?>-500">
                        Araña
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

        </figure>
    </div>

    <!--pophovers de envasadoras-->
    <!--HTST1_A-->
    <div data-popover id="HTST_1A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <h3 class="font-semibold text-gray-900 dark:text-white">
                <!--[if BLOCK]><![endif]--><?php if($HTST_1A->proceso == 'Produccion'): ?>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_1A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                    <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </h3>
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_1A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_1A =
                $HTST_1A->solicitudAnalisisLinea[count($HTST_1A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_1A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_1A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_1A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_1A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_1A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_1A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_1A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_1B-->
    <div data-popover id="HTST_1B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_1B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_1B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_1B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_1B =
                $HTST_1B->solicitudAnalisisLinea[count($HTST_1B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_1B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_1B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_1B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_1B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_1B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_1B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_1B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_1c-->
    <div data-popover id="HTST_1C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_1C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_1C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_1C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_1C =
                $HTST_1C->solicitudAnalisisLinea[count($HTST_1C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_1C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_1C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_1C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_1C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_1C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_1C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_1C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_2A-->
    <div data-popover id="HTST_2A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_2A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_2A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_2A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_2A =
                $HTST_2A->solicitudAnalisisLinea[count($HTST_2A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_2A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_2A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_2A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_2A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_2A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_2A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_2A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_2B-->
    <div data-popover id="HTST_2B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_1B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_2B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_2B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_2B =
                $HTST_2B->solicitudAnalisisLinea[count($HTST_2B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_2B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_2B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_2B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_2B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_2B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_2B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_2B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_2C-->
    <div data-popover id="HTST_2C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_2C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_2C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_2C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_2C =
                $HTST_2C->solicitudAnalisisLinea[count($HTST_2C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_2C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_2C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_2C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_2C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_2C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_2C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_2C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_3A-->
    <div data-popover id="HTST_3A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_3A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_3A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_3A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_3A =
                $HTST_3A->solicitudAnalisisLinea[count($HTST_3A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_3A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_3A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_3A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_3A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_3A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_3A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_3A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_3B-->
    <div data-popover id="HTST_3B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_3B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_3B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_3B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_3B =
                $HTST_3B->solicitudAnalisisLinea[count($HTST_3B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_3B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_3B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_3B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_3B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_3B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_3B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_3B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_3c-->
    <div data-popover id="HTST_3C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_3C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_3C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_3C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_3C =
                $HTST_3C->solicitudAnalisisLinea[count($HTST_3C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_3C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_3C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_3C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_3C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_3C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_3C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_3C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_4A-->
    <div data-popover id="HTST_4A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_4A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_4A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_4A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_4A =
                $HTST_4A->solicitudAnalisisLinea[count($HTST_4A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_4A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_4A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_4A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_4A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_4A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_4A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_4A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_4b-->
    <div data-popover id="HTST_4B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_4B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_4B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_4B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_4B =
                $HTST_4B->solicitudAnalisisLinea[count($HTST_4B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_4B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_4B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_4B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_4B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_4B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_4B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_4B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_4c-->
    <div data-popover id="HTST_4C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_4C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_4C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_4C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_4C =
                $HTST_4C->solicitudAnalisisLinea[count($HTST_4C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_4C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_4C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_4C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_4C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_4C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_4C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_4C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_5A-->
    <div data-popover id="HTST_5A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_5A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_5A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_5A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_5A =
                $HTST_5A->solicitudAnalisisLinea[count($HTST_5A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_5A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_5A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_5A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_5A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_5A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_5A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_4A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_5B-->
    <div data-popover id="HTST_5B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_5B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_5B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_5B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_5B =
                $HTST_5B->solicitudAnalisisLinea[count($HTST_5B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_5B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_5B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_5B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_5B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_5B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_5B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_5B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--HTST_5c-->
    <div data-popover id="HTST_5C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($HTST_5C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $HTST_5C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($HTST_5C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_HTST_5C =
                $HTST_5C->solicitudAnalisisLinea[count($HTST_5C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_HTST_5C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_HTST_5C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_HTST_5C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_HTST_5C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_HTST_5C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($HTST_5C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($HTST_5C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--ENVASADORAS DE UHT-->
    <!--UHT_1A-->
    <div data-popover id="UHT_1A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_1A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_1A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_1A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_1A =
                $UHT_1A->solicitudAnalisisLinea[count($UHT_1A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_1A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_1A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_1A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_1A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_1A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_1A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_1A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_1B-->
    <div data-popover id="UHT_1B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_1B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_1B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_1B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_1B =
                $UHT_1B->solicitudAnalisisLinea[count($UHT_1B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_1B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_1B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_1B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_1B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_1B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_1B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_1B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_1c-->
    <div data-popover id="UHT_1C-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_1C->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_1C->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_1C->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_1C =
                $UHT_1C->solicitudAnalisisLinea[count($UHT_1C->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_1C->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_1C->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_1C->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_1C->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_1C->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_1C->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_1C->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_2A-->
    <div data-popover id="UHT_2A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_2A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_2A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_2A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_2A =
                $UHT_2A->solicitudAnalisisLinea[count($UHT_2A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_2A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_2A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_2A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_2A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_2A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_2A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_2A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_2B-->
    <div data-popover id="UHT_2B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_2B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_2B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_2B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_2B =
                $UHT_2B->solicitudAnalisisLinea[count($UHT_2B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_2B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_2B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_2B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_2B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_2B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_2B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_2B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_3A-->
    <div data-popover id="UHT_3A-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_3A->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_3A->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_3A->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_3A =
                $UHT_3A->solicitudAnalisisLinea[count($UHT_3A->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_3A->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_3A->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_3A->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_3A->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_3A->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_3A->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_3A->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--UHT_3B-->
    <div data-popover id="UHT_3B-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($UHT_3B->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $UHT_3B->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($UHT_3B->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_UHT_3B =
                $UHT_3B->solicitudAnalisisLinea[count($UHT_3B->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_UHT_3B->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_UHT_3B->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_UHT_3B->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_UHT_3B->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_UHT_3B->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($UHT_3B->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($UHT_3B->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--Vasos -->
    <!--V1-->
    <div data-popover id="V1-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($V1->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $V1->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($V1->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_V1 =
                $V1->solicitudAnalisisLinea[count($V1->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_V1->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_V1->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_V1->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_V1->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_V1->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($V1->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($V1->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--V2-->
    <div data-popover id="V2-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($V2->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $V2->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($V2->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_V2 =
                $V2->solicitudAnalisisLinea[count($V2->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_V2->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_V2->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_V2->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_V2->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_V2->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($V2->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($V2->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--V3-->
    <div data-popover id="V3-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($V3->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $V3->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($V3->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_V3 =
                $V3->solicitudAnalisisLinea[count($V3->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_V3->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_V3->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_V3->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_V3->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_V3->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($V3->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($V3->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>

    <!--botella-->
    <div data-popover id="araña-popover" role="tooltip"
        class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-gray-800">
        <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-gray-700">
            <!--[if BLOCK]><![endif]--><?php if($araña->proceso == 'Produccion'): ?>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $araña->estadoDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class=" text-xs"><?php echo e($item->orp->codigo); ?> -
                <?php echo e($item->orp->producto->nombre); ?> <?php echo e($item->preparacion); ?></p> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-3 py-2">
            <?php if(count($araña->solicitudAnalisisLinea) > 0): ?>
            <p class="hidden"><?php echo e($ultimo_araña =
                $araña->solicitudAnalisisLinea[count($araña->solicitudAnalisisLinea)-1]); ?></p>
            <p><Span class="inline-block w-32">Estado Analisis</Span>: <?php echo e($ultimo_araña->estado); ?> </p>
            <p><Span class="inline-block w-32">Temp.</Span>:
                <?php echo e($ultimo_araña->analisisLinea->temperatura); ?> [°C]</p>
            <p><Span class="inline-block w-32">pH</Span>: <?php echo e($ultimo_araña->analisisLinea->ph); ?> </p>
            <p><Span class="inline-block w-32">Ac.</Span>: <?php echo e($ultimo_araña->analisisLinea->acidez); ?>[%]</p>
            <p><Span class="inline-block w-32">Sólidos</Span>: <?php echo e($ultimo_araña->analisisLinea->brix); ?> [°Bx]
            </p>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        </div>
        <!--boton de solicitar-->
        <!--[if BLOCK]><![endif]--><?php if($araña->proceso == 'Produccion'): ?>
        <div class="px-3 py-2">
            <button type="button" wire:click="solicitar(<?php echo e($araña->id); ?>)"
                class="px-3 py-2 text-xs font-medium text-center inline-flex items-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <svg class="w-3 h-3 fill-white me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                    <path
                        d="M288 0H160 128C110.3 0 96 14.3 96 32s14.3 32 32 32V196.8c0 11.8-3.3 23.5-9.5 33.5L10.3 406.2C3.6 417.2 0 429.7 0 442.6C0 480.9 31.1 512 69.4 512H378.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L329.5 230.4c-6.2-10.1-9.5-21.7-9.5-33.5V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288zM192 196.8V64h64V196.8c0 23.7 6.6 46.9 19 67.1L309.5 320h-171L173 263.9c12.4-20.2 19-43.4 19-67.1z" />
                </svg>
            </button>
        </div>
        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
        <div data-popper-arrow></div>
    </div>





</div><?php /**PATH C:\Users\rod_j\OneDrive\Escritorio\zoal_v2\resources\views/livewire/dashbord/planta.blade.php ENDPATH**/ ?>